package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Prosty serwlet do testowania filtrw.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class TodaysSpecialServlet extends HttpServlet {
  private String title, picture;
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    updateSpecials();
    response.setCharacterEncoding("UTF-8");
    response.setContentType("text/html");
    PrintWriter out = response.getWriter();
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    out.println
      (docType +
       "<HTML>\n" +
       "<HEAD><TITLE>Dzisiejsza oferta dnia</TITLE></HEAD>\n" +
       "<BODY BGCOLOR=\"WHITE\">\n" +
       "<CENTER>\n" +
       "<H1>Dzisiejsza oferta dnia: " + title + "!</H1>\n" +
       "<IMG SRC=\"images/" + picture + "\"\n" +
       "     ALT=\"" + title + "\">\n" +
       "<BR CLEAR=\"ALL\">\n" +
       "Oferta specjalna: Za cen dwch sztuk \n" +
       "<I>drug sztuk dostaniesz za darmo!</I>\n" +
       "</BODY></HTML>");
  }

  // Losowy wybr jednego z trzech obrazkw filtrw.
  private void updateSpecials() {
    double num = Math.random();
    if (num < 0.333) {
      title = "Filtry powietrza";
      picture = "air-filter.jpg";
    } else if (num < 0.666) {
      title = "Filtry do kawy";
      picture = "coffee-filter.gif";
    } else {
      title = "Filtry do pomp";
      picture = "pump-filter.jpg";
    }
  }
}
